<?php
include("db.php"); // Include your database connection

// Set content type to JSON
header('Content-Type: application/json');

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Get the raw POST data
    $rawData = file_get_contents('php://input');

    // Decode the JSON input
    $data = json_decode($rawData, true);

    // Check for JSON decoding errors
    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid JSON input', 'error_detail' => json_last_error_msg()]);
        exit();
    }

    // Validate required fields
    if (!isset($data['category_ID'])) {
        echo json_encode(['status' => 'error', 'message' => 'category_ID is required']);
        exit();
    }

    // Assign and sanitize input data
    $categoryId = intval($data['category_ID']);
    $name = isset($data['name']) ? $conn->real_escape_string($data['name']) : null;
    $image = isset($data['image']) ? $conn->real_escape_string($data['image']) : null;

    // Build the update query dynamically
    $updateFields = [];
    if ($name !== null) $updateFields[] = "name = '$name'";
    if ($image !== null) $updateFields[] = "image = '$image'";

    // Check if there are fields to update
    if (empty($updateFields)) {
        echo json_encode(['status' => 'error', 'message' => 'No fields to update']);
        exit();
    }

    $updateFieldsString = implode(", ", $updateFields);
    $updateQuery = "UPDATE categories SET $updateFieldsString WHERE category_ID = $categoryId";

    // Execute the update query
    if ($conn->query($updateQuery) === TRUE) {
        if ($conn->affected_rows > 0) {
            echo json_encode(['status' => 'success', 'message' => 'Category updated successfully']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'No changes made or category not found']);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to update category', 'error_detail' => $conn->error]);
    }
} else {
    // Handle invalid request method
    echo json_encode(['status' => 'error', 'message' => 'Only POST method is allowed']);
}

$conn->close();
?>
